CREATE TABLE [dbo].[BED_CLEAN]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[BED_UID] [uniqueidentifier] NOT NULL,
[WARD_UID] [uniqueidentifier] NULL,
[DIVISION_UID] [uniqueidentifier] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[TYPE_OF_CLEAN_ID] [int] NULL,
[MANUAL_REQUEST_ID] [int] NULL,
[ACCEPTED_DATE] [datetime] NULL,
[ACCEPTED_BY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COMPLETED_DATE] [datetime] NULL,
[COMPLETED_BY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__BED_CLEAN___ssis__23DE44F1] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[LAST_EDITED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LAST_EDIT_DATE] [datetime] NULL,
[EMS_NOTIFY] [nvarchar] (10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REQUESTED_DATE] [datetime] NULL,
[SPECIAL_INSTRUCTIONS] [nvarchar](500) NULL,
[COMMENT] [nvarchar](500) NULL,
[COMMENTED_BY] [nvarchar](250) NULL,
[COMMENTED_DATE] [datetime] NULL,
[VACATED_DATE] [datetime] NULL,
[EVENT_TYPE] [nvarchar](3) NULL,
[EVENT_IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] [datetime] NOT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE trigger [dbo].[BED_CLEAN_tgg_ssis_delete] on [dbo].[BED_CLEAN] after delete as begin  delete [dbo].[BED_CLEAN_ssisdel] from [deleted] _xyz where [dbo].[BED_CLEAN_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[BED_CLEAN_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end

GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE trigger [dbo].[BED_CLEAN_tgg_ssis_insert] on [dbo].[BED_CLEAN] after insert as begin delete [dbo].[BED_CLEAN_ssisdel]  from [inserted] _xyz where [dbo].[BED_CLEAN_ssisdel].[ID]=[_xyz].[ID] end

GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Bed_Clean_AfterDelete] 
   ON  [dbo].[BED_CLEAN] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     BEGIN 
		INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Clean_H]
			(ID, DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT ID, DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, CREATION_UTC_DATE, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 END		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Bed_Clean_AfterInsert] 
   ON  [dbo].[BED_CLEAN] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
    	INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Clean_H]
			(ID, DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT ID, DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, CREATION_UTC_DATE, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Bed_Clean_AfterUpdate] 
   ON  [dbo].[BED_CLEAN] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Clean_H]
			(ID, DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT ID, DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, CREATION_UTC_DATE, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO


CREATE TRIGGER [dbo].[utg_Bed_Clean_InsteadOfInsert] 
   ON  [dbo].[BED_CLEAN]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[Bed_Clean]
			(DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, _ssis_timestamp, CREATED, CREATEDBY)
		SELECT DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;	
	ELSE
		INSERT INTO [dbo].[Bed_Clean]
			(DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, _ssis_timestamp)
		SELECT DOMAIN_ID, BED_UID, WARD_UID, DIVISION_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY, LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS, COMMENT, COMMENTED_BY, COMMENTED_DATE, VACATED_DATE, EVENT_TYPE, EVENT_IEN, _ssis_timestamp
			FROM inserted;
	
END
   
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO


CREATE TRIGGER [dbo].[utg_Bed_Clean_InsteadOfUpdate] 
   ON  [dbo].[BED_CLEAN] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Bed_Clean]
			SET DOMAIN_ID = inserted.DOMAIN_ID,		
				BED_UID = inserted.BED_UID,
				WARD_UID = inserted.WARD_UID,
				DIVISION_UID = inserted.DIVISION_UID, 
				TYPE_OF_CLEAN_ID = inserted.TYPE_OF_CLEAN_ID,
				MANUAL_REQUEST_ID = inserted.MANUAL_REQUEST_ID,
				ACCEPTED_DATE = inserted.ACCEPTED_DATE,
				ACCEPTED_BY = inserted.ACCEPTED_BY,
				COMPLETED_DATE = inserted.COMPLETED_DATE,
				COMPLETED_BY = inserted.COMPLETED_BY,
				LAST_EDITED_BY = inserted.LAST_EDITED_BY,
				LAST_EDIT_DATE = inserted.LAST_EDIT_DATE,
				REQUESTED_DATE = inserted.REQUESTED_DATE,
				VISTA_SITE_UID = inserted.VISTA_SITE_UID,
				EMS_NOTIFY = inserted.EMS_NOTIFY,
				SPECIAL_INSTRUCTIONS = inserted.SPECIAL_INSTRUCTIONS, 
				COMMENT = inserted.COMMENT, 
				COMMENTED_BY = inserted.COMMENTED_BY, 
				COMMENTED_DATE = inserted.COMMENTED_DATE,
				VACATED_DATE = inserted.VACATED_DATE,
				EVENT_TYPE = inserted.EVENT_TYPE,
				EVENT_IEN = inserted.EVENT_IEN,			
				_ssis_timestamp = current_timestamp,
				UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
				UPDATED = GETUTCDATE()
			FROM [dbo].[Bed_Clean]
				INNER JOIN inserted ON inserted.id = [dbo].[Bed_Clean].id;
	 ELSE
		UPDATE [dbo].[Bed_Clean]
			SET DOMAIN_ID = inserted.DOMAIN_ID,	
				BED_UID = inserted.BED_UID,
				WARD_UID = inserted.WARD_UID,
				DIVISION_UID = inserted.DIVISION_UID, 
				TYPE_OF_CLEAN_ID = inserted.TYPE_OF_CLEAN_ID,
				MANUAL_REQUEST_ID = inserted.MANUAL_REQUEST_ID,
				ACCEPTED_DATE = inserted.ACCEPTED_DATE,
				ACCEPTED_BY = inserted.ACCEPTED_BY,
				COMPLETED_DATE = inserted.COMPLETED_DATE,
				COMPLETED_BY = inserted.COMPLETED_BY,
				LAST_EDITED_BY = inserted.LAST_EDITED_BY,
				LAST_EDIT_DATE = inserted.LAST_EDIT_DATE,
				REQUESTED_DATE = inserted.REQUESTED_DATE,
				VISTA_SITE_UID = inserted.VISTA_SITE_UID,
				EMS_NOTIFY = inserted.EMS_NOTIFY, 
				SPECIAL_INSTRUCTIONS = inserted.SPECIAL_INSTRUCTIONS, 
				COMMENT = inserted.COMMENT, 
				COMMENTED_BY = inserted.COMMENTED_BY, 
				COMMENTED_DATE = inserted.COMMENTED_DATE,
				VACATED_DATE = inserted.VACATED_DATE,
				EVENT_TYPE = inserted.EVENT_TYPE,
				EVENT_IEN = inserted.EVENT_IEN,
				_ssis_timestamp = current_timestamp
			FROM [dbo].[Bed_Clean]
				INNER JOIN inserted ON inserted.id = [dbo].[Bed_Clean].id;

END
GO

--Constraints
ALTER TABLE [dbo].[BED_CLEAN] ADD CONSTRAINT [PK_BED_CLEAN] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[BED_CLEAN] ADD CONSTRAINT [FK_BED_CLEAN_CONCEPT_MANUAL_REQUEST] FOREIGN KEY ([MANUAL_REQUEST_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[BED_CLEAN] ADD CONSTRAINT [FK_BED_CLEAN_CONCEPT_TYPE_OF_CLEAN] FOREIGN KEY ([TYPE_OF_CLEAN_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[BED_CLEAN] ADD  CONSTRAINT [DF_BED_CLEAN_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_AND_DATES] ON [dbo].[BED_CLEAN] 
(
	[VISTA_SITE_UID] ASC,
	[ACCEPTED_DATE] ASC,
	[COMPLETED_DATE] ASC,
	[REQUESTED_DATE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [dbo].[BED_CLEAN] 
(
	[BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_BED_WARD] ON [dbo].[BED_CLEAN] 
(
	[BED_UID] ASC,
	[WARD_UID] ASC,
	[TYPE_OF_CLEAN_ID] ASC,
	[MANUAL_REQUEST_ID] ASC
)
INCLUDE ( [EMS_NOTIFY]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_ACT_BED] ON [dbo].[BED_CLEAN] 
(
	[BED_UID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_ACT_ID_AND_DATES] ON [dbo].[BED_CLEAN] 
(
	[ID] ASC
)
INCLUDE ( [ACCEPTED_DATE],
[COMPLETED_DATE],
[REQUESTED_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_REQUESTED_DATE_COMPLETED_DATE] ON [dbo].[BED_CLEAN] 
(
	[REQUESTED_DATE] ASC,
	[COMPLETED_DATE] ASC
)
INCLUDE ([ID],
[DOMAIN_ID],
[BED_UID],
[WARD_UID],
[EVENT_IEN])
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_CLEAN] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_ACCEPTED_DATE_COMPLETED_DATE] ON [dbo].[BED_CLEAN] 
(
	[ACCEPTED_DATE] ASC,
	[COMPLETED_DATE] ASC,
	[REQUESTED_DATE] ASC,
	[VACATED_DATE] ASC,
	[EVENT_IEN] ASC
)
INCLUDE ( [WARD_UID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_COMPLETED_DATE_ACCEPTED_DATE] ON [dbo].[BED_CLEAN] 
(
	[COMPLETED_DATE] ASC,
	[ACCEPTED_DATE] ASC,
	[REQUESTED_DATE] ASC,
	[VACATED_DATE] ASC,
	[EVENT_IEN] ASC
)
INCLUDE ( [WARD_UID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_COMPLETED_DATE_COMPLETED_BY_REQUESTED_DATE] ON [dbo].[BED_CLEAN] 
(
	[COMPLETED_DATE] ASC,
	[COMPLETED_BY] ASC,
	[REQUESTED_DATE] ASC
)
INCLUDE ( [WARD_UID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX [IDX_WARD_UID_COMPLETED_DATE_REQUESTED_DATE_UTC] ON [dbo].[BED_CLEAN] 
([WARD_UID],[COMPLETED_DATE], [REQUESTED_DATE]) 
INCLUDE ([COMPLETED_BY], [CREATION_UTC_DATE])
GO

CREATE INDEX [IDX_WARD_UID_COMPLETED_DATE_REQUESTED_DATE] ON [dbo].[BED_CLEAN] 
([WARD_UID],[COMPLETED_DATE], [REQUESTED_DATE]) 
INCLUDE ([ID], [DOMAIN_ID], [BED_UID], [TYPE_OF_CLEAN_ID], [MANUAL_REQUEST_ID], [ACCEPTED_DATE], [ACCEPTED_BY], [COMPLETED_BY], [LAST_EDITED_BY], [LAST_EDIT_DATE], [EMS_NOTIFY], [COMMENT], [COMMENTED_BY], [COMMENTED_DATE], [VACATED_DATE], [EVENT_IEN])	
GO

CREATE NONCLUSTERED INDEX [IDX_WARD_UID_DATES_EVENT_IEN] ON [dbo].[BED_CLEAN] 
([WARD_UID],[COMPLETED_DATE],[ACCEPTED_DATE],[REQUESTED_DATE],[VACATED_DATE],[EVENT_IEN])
INCLUDE ([CREATION_UTC_DATE])
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Table storing information about bed cleaning. ', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The EMS user that accepted the bed cleaning request.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'ACCEPTED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the bed cleaning request was accepted by a EMS user.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'ACCEPTED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Bed clean table.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Bed''s id (EIS place reference).', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The EMS user that completed the bed cleaning request.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'COMPLETED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the bed cleaning request was completed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'COMPLETED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates whether a notification is done to the EMS Staff.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'EMS_NOTIFY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was last changed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'LAST_EDIT_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was last changed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'LAST_EDITED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates whether the cleaning request is manual or automatic.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'MANUAL_REQUEST_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date of the the bed cleaning request.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'REQUESTED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type of cleaning id (concept).', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'TYPE_OF_CLEAN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the bed''s facility.', 'SCHEMA', N'dbo', 'TABLE', N'BED_CLEAN', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Field that contains special instructions.' , N'SCHEMA', N'dbo', N'TABLE', N'BED_CLEAN', N'COLUMN', N'SPECIAL_INSTRUCTIONS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Comments associated to bed clean.' , N'SCHEMA', N'dbo', N'TABLE', N'BED_CLEAN', N'COLUMN', N'COMMENT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of the user when a comment was added and modified.' , N'SCHEMA', N'dbo', N'TABLE', N'BED_CLEAN', N'COLUMN', N'COMMENTED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when a comment was added or modified.' , N'SCHEMA', N'dbo', N'TABLE', N'BED_CLEAN', N'COLUMN', N'COMMENTED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed''s ward id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The division id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN', @level2type=N'COLUMN',@level2name=N'DIVISION_UID'
GO